// Xtiende static interactions
(function () {
  'use strict';

  // ----- Data (extracted from src/app/data/home.ts) -----
  const animatedWords = ["Conecta", "Innova", "Xtiende", "Simplifica"];

  const pillars = [
    { title: 'Simplicidad', description: 'Una plataforma intuitiva que elimina intermediarios y agiliza procesos.' },
    { title: 'Innovación', description: 'Herramientas de IA que automatizan tareas y optimizan resultados.' },
    { title: 'Confianza', description: 'Sistemas de feedback que garantizan transacciones seguras y transparentes.' },
    { title: 'Escalabilidad', description: 'Soluciones para negocios pequeños, medianos y grandes por igual.' }
  ];

  const features = {
    proveedores: [
      { icon: '🌐', title: 'Amplía tu Alcance de Mercado', description: 'Participa en Cotizaciones Abiertas (RFQs), publica en la Vitrina de Productos y conecta con clientes locales e internacionales para convertir oportunidades en ventas.' },
      { icon: '⭐', title: 'Destaca tu Negocio', description: 'Crea una vitrina de productos altamente estética y profesional. Personaliza tu catálogo de forma intuitiva para destacar sobre el resto.' },
      { icon: '📦', title: 'Liquida Inventario con Agilidad', description: 'Transforma el stock acumulado en ganancias. Atrae a compradores mayoristas con ofertas claras y reduce costos de almacenamiento.' },
      { icon: '🎯', title: 'Encuentra Compradores Ideales', description: 'Usa la Búsqueda Inteligente para segmentar por categoría o necesidad y recibe alertas personalizadas de oportunidades de negocio.' },
      { icon: '🛡️', title: 'Fortalece tu Reputación', description: 'Aprovecha el sistema de feedback para recibir reseñas que refuercen tu credibilidad y consulta los antecedentes de los compradores.' },
      { icon: '📢', title: 'Espacio de Ofertas y Novedades', description: 'Publica ofertas, promociones exclusivas, certificaciones e innovaciones en tu propio blog de empresa para notificar a clientes selectos.' },
      { icon: '🤝', title: 'Participa en una Comunidad Activa', description: 'Únete a Xtiende Conecta para resolver dudas, pedir recomendaciones y forjar alianzas estratégicas, dirigiendo tus publicaciones a la audiencia correcta.' }, 
      { icon: '➕', title: 'Entre otras funciones', description: '' },
    ],
    compradores: [
      { icon: '💰', title: 'Descubre Ofertas Inmejorables', description: 'Publica Cotizaciones Abiertas (RFQs) detallando tus requerimientos y recibe propuestas de proveedores verificados para ahorrar tiempo y dinero.' },
      { icon: '🔍', title: 'Localiza Proveedores con Precisión', description: 'Filtra por producto, región o especialidad. Accede a perfiles detallados con catálogos y reseñas para simplificar la selección.' },
      { icon: '🤖', title: 'Búsqueda Potenciada por IA', description: 'Describe lo que buscas, incluso requerimientos complejos, y obtén resultados optimizados por ubicación, disponibilidad y urgencia.' },
      { icon: '✅', title: 'Toma Decisiones Seguras', description: 'Consulta el sistema de feedback para revisar calificaciones y experiencias previas. Trabaja solo con socios que cumplan tus estándares.' },
      { icon: '🏷️', title: 'Aprovecha Ofertas de Liquidación', description: 'Accede a descuentos exclusivos en grandes volúmenes. Compra inventario excedente a costos reducidos y maximiza tu inversión.' },
      { icon: '🤝', title: 'Participa en una Comunidad Activa', description: 'Accede a Xtiende Conecta para resolver dudas, descubrir tendencias y forjar alianzas estratégicas que potencien tu cadena de suministro.' },
      { icon: '➕', title: 'Entre otras funciones', description: '' },
    ]
  };

  

 

  // ----- Helpers -----
  function el(tag, cls, content) {
    const e = document.createElement(tag);
    if (cls) e.className = cls;
    if (content != null) e.textContent = content;
    return e;
  }

  function setSwitchIndicator(indicator, activeBtn) {
    const track = indicator.parentElement;
    if (!track || !activeBtn) return;
    const width = activeBtn.offsetWidth;
    const left = activeBtn.offsetLeft;
    indicator.style.width = width + 'px';
    indicator.style.transform = `translateX(${Math.max(0, left - 4)}px)`; // account for left:4px in CSS
  }

  // ----- Render functions -----
  function renderPillars() {
    const grid = document.getElementById('pillars-grid');
    if (!grid) return;
    grid.innerHTML = '';
    for (const p of pillars) {
      const card = el('article', 'pillar glass');
      const icon = el('span', 'pillar__icon', '');
      icon.setAttribute('aria-hidden', 'true');
      const title = el('h3', 'pillar__title', p.title);
      const desc = el('p', 'pillar__desc', p.description);
      card.append(icon, title, desc);
      grid.append(card);
    }
  }

  function renderFeatures(kind) {
    const list = document.getElementById('features-track');
    if (!list) return;
    list.innerHTML = '';
    const items = features[kind] || [];
    
    // Mapeo de iconos a clases CSS
    const iconClasses = {
      '🌐': 'icon-globe',
      '⭐': 'icon-star', 
      '📦': 'icon-package',
      '🎯': 'icon-target',
      '🛡️': 'icon-shield',
      '📢': 'icon-megaphone',
      '🤝': 'icon-handshake',
      '💰': 'icon-money',
      '🔍': 'icon-search',
      '🤖': 'icon-robot',
      '✅': 'icon-check',
      '🏷️': 'icon-tag'
    };
    
    for (let i = 0; i < items.length; i++) {
      const f = items[i];
      const isLastCard = i === items.length - 1;
      const card = el('article', isLastCard ? 'feature-card feature-card--coming-soon glass' : 'feature-card glass');
      
      if (isLastCard) {
        // Diseño especial para la última card
        const iconContainer = el('div', 'coming-soon__icon-container');
        const gear1 = el('span', 'coming-soon__gear coming-soon__gear--1', '⚙️');
        const gear2 = el('span', 'coming-soon__gear coming-soon__gear--2', '⚙️');
        iconContainer.append(gear1, gear2);
        
        const title = el('h4', 'feature-card__title coming-soon__title', 'Próximamente');
        const subtitle = el('p', 'coming-soon__subtitle', 'Nuevas funciones increíbles');
        const desc = el('p', 'feature-card__desc coming-soon__desc', 'Estamos desarrollando características innovadoras que revolucionarán tu experiencia B2B');
        
        card.append(iconContainer, title, subtitle, desc);
      } else {
        const iconClass = iconClasses[f.icon] || '';
        const icon = el('span', `feature-card__icon ${iconClass}`, '');
        icon.setAttribute('aria-hidden', 'true');
        const title = el('h4', 'feature-card__title', f.title);
        const desc = el('p', 'feature-card__desc', f.description);
        card.append(icon, title, desc);
      }
      
      list.append(card);
    }
  }

  function renderHow() {
    const grid = document.getElementById('how-grid');
    if (!grid) return;
    grid.innerHTML = '';
    for (const s of howItWorksSteps) {
      const card = el('article', 'step glass');
      const icon = el('span', 'step__icon', '');
      icon.setAttribute('aria-hidden', 'true');
      const title = el('h4', 'step__title', s.title);
      const desc = el('p', 'step__desc', s.description);
      card.append(icon, title, desc);
      grid.append(card);
    }
  }

  function renderFaq() {
    const wrap = document.getElementById('faq-list');
    if (!wrap) return;
    wrap.innerHTML = '';
    faqData.forEach((item, idx) => {
      const container = el('div', 'faq__item');
      const qBtn = el('button', 'faq__q');
      qBtn.type = 'button';
      qBtn.setAttribute('aria-expanded', 'false');
      qBtn.setAttribute('aria-controls', `faq-a-${idx}`);
      qBtn.innerHTML = `<span>${item.question}</span>`;
      const ic = el('span', 'faq__icon', '▾');
      ic.setAttribute('aria-hidden', 'true');
      qBtn.append(ic);

      const a = el('div', 'faq__a');
      a.id = `faq-a-${idx}`;
      const p = el('p', '', item.answer);
      a.append(p);

      qBtn.addEventListener('click', () => {
        const isOpen = a.classList.toggle('is-open');
        qBtn.setAttribute('aria-expanded', String(isOpen));
        if (isOpen) {
          a.style.maxHeight = a.scrollHeight + 'px';
        } else {
          a.style.maxHeight = '0px';
        }
      });

      container.append(qBtn, a);
      wrap.append(container);
    });
  }

  // ----- Behavior -----
  function enableDragScroll(el) {
    if (!el) return;
    let isDown = false;
    let startX = 0;
    let startY = 0;
    let startScroll = 0;
    let moved = false;
    let isHorizontalDrag = false;

    const onDown = (e) => {
      isDown = true;
      moved = false;
      isHorizontalDrag = false;
      startX = e.clientX || (e.touches && e.touches[0].clientX);
      startY = e.clientY || (e.touches && e.touches[0].clientY);
      startScroll = el.scrollLeft;
      el.style.cursor = 'grabbing';
    };

    const onMove = (e) => {
      if (!isDown) return;
      const currentX = e.clientX || (e.touches && e.touches[0].clientX);
      const currentY = e.clientY || (e.touches && e.touches[0].clientY);
      const dx = currentX - startX;
      const dy = currentY - startY;
      
      // Determinar si es un drag horizontal o vertical
      if (!moved && (Math.abs(dx) > 3 || Math.abs(dy) > 3)) {
        moved = true;
        isHorizontalDrag = Math.abs(dx) > Math.abs(dy);
      }
      
      // Solo aplicar scroll horizontal y preventDefault si es un drag horizontal
      if (moved && isHorizontalDrag) {
        el.scrollLeft = startScroll - dx;
        e.preventDefault();
      }
    };

    const onUp = () => {
      isDown = false;
      el.style.cursor = 'grab';
    };

    el.addEventListener('mousedown', onDown, { passive: true });
    el.addEventListener('mousemove', onMove, { passive: false });
    el.addEventListener('mouseup', onUp, { passive: true });
    el.addEventListener('mouseleave', onUp, { passive: true });

    el.addEventListener('touchstart', onDown, { passive: true });
    el.addEventListener('touchmove', onMove, { passive: false });
    el.addEventListener('touchend', onUp, { passive: true });
    el.addEventListener('touchcancel', onUp, { passive: true });

    el.addEventListener('click', (e) => {
      if (moved && isHorizontalDrag) {
        e.preventDefault();
      }
    }, true);

    // Improve desktop UX
    el.style.cursor = 'grab';
  }
  
  // Keyboard navigation for horizontal scrollers (left/right arrows)
  function enableKeyboardScroll(el, itemSelector) {
    if (!el) return;
    el.addEventListener('keydown', (e) => {
      if (e.key !== 'ArrowRight' && e.key !== 'ArrowLeft') return;
      e.preventDefault();
      const item = el.querySelector(itemSelector);
      const styles = getComputedStyle(el);
      const gap = parseInt(styles.columnGap || styles.gap || '0', 10) || 14;
      const delta = item ? (item.clientWidth + gap) * 1.5 : 320;
      const dir = e.key === 'ArrowRight' ? 1 : -1;
      el.scrollBy({ left: dir * delta, behavior: 'smooth' });
    });
  }
  function initHero() {
    // slides
    const slides = Array.from(document.querySelectorAll('.hero__slide'));
    let idx = slides.findIndex(s => s.classList.contains('is-active'));
    if (idx < 0) idx = 0;
    setInterval(() => {
      if (!slides.length) return;
      slides[idx].classList.remove('is-active');
      idx = (idx + 1) % slides.length;
      slides[idx].classList.add('is-active');
    }, 5000);

    // animated word
    const wordEl = document.querySelector('.animated-word');
    let w = 0;
    if (wordEl) {
      setInterval(() => {
        w = (w + 1) % animatedWords.length;
        wordEl.textContent = animatedWords[w];
      }, 2200);
    }
  }

  function initFeatures() {
    const tabs = Array.from(document.querySelectorAll('.switch__btn'));
    const indicator = document.getElementById('switch-indicator');
    const list = document.getElementById('features-track');
    const prevBtn = document.getElementById('features-prev');
    const nextBtn = document.getElementById('features-next');

    let current = 'proveedores';
    renderFeatures(current);
    requestAnimationFrame(() => {
      const activeBtn = tabs.find(t => t.classList.contains('is-active')) || tabs[0];
      setSwitchIndicator(indicator, activeBtn);
      // Enable drag scroll once items are in DOM
      enableDragScroll(list);
    });

    // Arrow navigation
    if (prevBtn && nextBtn && list) {
      prevBtn.addEventListener('click', () => {
        const scrollAmount = list.clientWidth * 0.8;
        list.scrollBy({ left: -scrollAmount, behavior: 'smooth' });
      });

      nextBtn.addEventListener('click', () => {
        const scrollAmount = list.clientWidth * 0.8;
        list.scrollBy({ left: scrollAmount, behavior: 'smooth' });
      });
    }

    tabs.forEach(btn => {
      btn.addEventListener('click', () => {
        if (btn.classList.contains('is-active')) return;
        tabs.forEach(b => b.classList.remove('is-active'));
        btn.classList.add('is-active');
        current = btn.dataset.tab || 'proveedores';
        renderFeatures(current);
        setSwitchIndicator(indicator, btn);
        // Re-enable drag behavior after re-render
        enableDragScroll(list);
        list?.scrollTo({ left: 0, behavior: 'smooth' });
      });
    });

    // NOTE: Features navigation is now handled by initCarouselNav
    // Removed old prev/next event listeners to avoid conflicts

    list?.addEventListener('keydown', (e) => {
      if (e.key === 'ArrowRight') { e.preventDefault(); }
      if (e.key === 'ArrowLeft') { e.preventDefault(); }
    });

    window.addEventListener('resize', () => {
      const activeBtn = tabs.find(t => t.classList.contains('is-active')) || tabs[0];
      setSwitchIndicator(indicator, activeBtn);
    });
  }

  // Initialize carousel navigation for any section
  function initCarouselNav(trackId, prevId, nextId, itemSelector) {
    const track = document.getElementById(trackId);
    const prevBtn = document.getElementById(prevId);
    const nextBtn = document.getElementById(nextId);
    
    if (!track || !prevBtn || !nextBtn) return;
    
    const items = track.querySelectorAll(itemSelector);
    if (items.length === 0) return;
    
    // Regular carousel behavior for all sections
    const itemWidth = items[0].offsetWidth + parseFloat(getComputedStyle(items[0]).marginRight);
    
    prevBtn.addEventListener('click', () => scrollByCards(-1));
    nextBtn.addEventListener('click', () => scrollByCards(1));
    
    function scrollByCards(direction) {
      const scrollAmount = itemWidth * direction;
      track.scrollBy({ left: scrollAmount, behavior: 'smooth' });
    }
  }

  function initPillarsCarousel() {
    const track = document.getElementById('pillars-track');
    const prevBtn = document.getElementById('pillars-prev');
    const nextBtn = document.getElementById('pillars-next');
    
    if (!track || !prevBtn || !nextBtn) return;
    
    const items = track.querySelectorAll('.pillar-item');
    if (items.length === 0) return;
    
    let currentIndex = 0;
    
    function updateCarousel() {
      // Get current dimensions
      const containerWidth = track.parentElement.offsetWidth;
      const itemWidth = items[0].offsetWidth;
      const gap = 16; // 1rem gap
      
      // Calculate center position for current card
      const totalItemWidth = itemWidth + gap;
      const centerOffset = (containerWidth - itemWidth) / 2;
      const translateX = centerOffset - (currentIndex * totalItemWidth);
      
      track.style.transform = `translateX(${translateX}px)`;
    }
    
    prevBtn.addEventListener('click', () => {
      if (currentIndex > 0) {
        currentIndex--;
        updateCarousel();
      }
    });
    
    nextBtn.addEventListener('click', () => {
      if (currentIndex < items.length - 1) {
        currentIndex++;
        updateCarousel();
      }
    });
    
    // Initialize and handle resize
    updateCarousel();
    window.addEventListener('resize', updateCarousel);
  }

  function initBenefitsCarousel() {
    const track = document.getElementById('benefits-track');
    const prevBtn = document.getElementById('benefits-prev');
    const nextBtn = document.getElementById('benefits-next');
    
    if (!track || !prevBtn || !nextBtn) return;
    
    const items = track.querySelectorAll('.benefit-item');
    if (items.length === 0) return;
    
    let currentIndex = 0;
    
    function updateCarousel() {
      // Get current dimensions
      const containerWidth = track.parentElement.offsetWidth;
      const itemWidth = items[0].offsetWidth;
      const gap = 16; // 1rem gap
      
      // Calculate center position for current card
      const totalItemWidth = itemWidth + gap;
      const centerOffset = (containerWidth - itemWidth) / 2;
      const translateX = centerOffset - (currentIndex * totalItemWidth);
      
      track.style.transform = `translateX(${translateX}px)`;
    }
    
    prevBtn.addEventListener('click', () => {
      if (currentIndex > 0) {
        currentIndex--;
        updateCarousel();
      }
    });
    
    nextBtn.addEventListener('click', () => {
      if (currentIndex < items.length - 1) {
        currentIndex++;
        updateCarousel();
      }
    });
    
    // Initialize and handle resize
    updateCarousel();
    window.addEventListener('resize', updateCarousel);
  }

  // Navbar functionality
  function initNavbar() {
    const navbar = document.querySelector('.navbar');
    const navbarToggle = document.querySelector('.navbar-toggle');
    const navbarMenu = document.querySelector('.navbar-menu');
    const navbarLinks = document.querySelectorAll('.navbar-link');

    // Scroll effect
    function handleScroll() {
      if (window.scrollY > 50) {
        navbar.classList.add('scrolled');
      } else {
        navbar.classList.remove('scrolled');
      }
    }

    window.addEventListener('scroll', handleScroll);

    // Mobile menu toggle
    if (navbarToggle && navbarMenu) {
      navbarToggle.addEventListener('click', () => {
        navbarToggle.classList.toggle('active');
        navbarMenu.classList.toggle('active');
      });
    }

    // Smooth scroll
    navbarLinks.forEach(link => {
      link.addEventListener('click', (e) => {
        e.preventDefault();
        const targetId = link.getAttribute('href');
        const targetSection = document.querySelector(targetId);
        if (targetSection) {
          targetSection.scrollIntoView({ behavior: 'smooth' });
          // Close mobile menu
          navbarToggle?.classList.remove('active');
          navbarMenu?.classList.remove('active');
        }
      });
    });
  }

  // Boot
  document.addEventListener('DOMContentLoaded', () => {
    initNavbar();
    renderHow();
    renderFaq();
    initHero();
    initFeatures();
    
    // Initialize custom carousels
    initPillarsCarousel();
    initBenefitsCarousel();
    
    // Drag to scroll for all carousels
    const howGrid = document.getElementById('how-grid');
    const featuresTrack = document.getElementById('features-track');
    enableDragScroll(howGrid);
    enableDragScroll(featuresTrack);
    
    // Keyboard support
    enableKeyboardScroll(howGrid, '.step');
    enableKeyboardScroll(featuresTrack, '.feature-card');
    
    // Initialize newsletter
    initNewsletter();
  });
})();

// Newsletter form functionality
function initNewsletter() {
  const form = document.getElementById('newsletter-form');
  const submitBtn = form.querySelector('.newsletter-btn');

  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      
      // Get form data
      const formData = new FormData(form);
      
      // Show loading state
      const originalText = submitBtn.innerHTML;
      submitBtn.innerHTML = '⏳ Enviando...';
      submitBtn.disabled = true;
      
      // Submit to Formspree
      fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
          'Accept': 'application/json'
        }
      }).then(response => {
        if (response.ok) {
          // Show success icon
          submitBtn.innerHTML = '🎫 ¡Suscrito!';
          submitBtn.style.background = 'linear-gradient(135deg, #28a745, #20c997)';
          form.reset();
          
          // Reset button after 3 seconds
          setTimeout(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.style.background = '';
            submitBtn.disabled = false;
          }, 3000);
        } else {
          // Show error state
          submitBtn.innerHTML = '❌ Error';
          submitBtn.style.background = 'linear-gradient(135deg, #dc3545, #e74c3c)';
          
          setTimeout(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.style.background = '';
            submitBtn.disabled = false;
          }, 3000);
        }
      }).catch(error => {
        // Show error state
        submitBtn.innerHTML = '❌ Error';
        submitBtn.style.background = 'linear-gradient(135deg, #dc3545, #e74c3c)';
        
        setTimeout(() => {
          submitBtn.innerHTML = originalText;
          submitBtn.style.background = '';
          submitBtn.disabled = false;
        }, 3000);
      });
    });
  }
}
